/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.TimeProtectionParameter;

public class OffDelayParameter
extends TimeProtectionParameter {
    static final long serialVersionUID = 0L;
    private int offDelayParameterSerializedDataVersion = 1;
    protected static final int READY = 0;
    protected static final int WAITING = 1;
    protected static final int RUNNING = 2;

    public OffDelayParameter() {
    }

    public OffDelayParameter(Block block) {
        super(block);
        this.fParameter = 2;
        this.fData = 1;
        this.fAllocatedTimer = 1;
        this.fState = 0;
        this.setParameterNameKeys();
    }

    public boolean getValue(boolean trigger, boolean reset) {
        boolean value = this.calculateValue(trigger, reset);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return value;
    }

    protected boolean calculateValue(boolean trigger, boolean reset) {
        if (reset) {
            this.fState = 0;
            this.getTimer().reset();
            return false;
        }
        if (this.fState == 0) {
            if (trigger) {
                this.fState = 1;
                return true;
            }
            this.getTimer().reset();
        }
        if (this.fState == 1) {
            if (!trigger) {
                this.getTimer().start();
                this.fState = 2;
            } else {
                this.getTimer().reset();
            }
            return true;
        }
        if (this.fState == 2) {
            if (trigger) {
                this.fState = 1;
                return true;
            }
            if (this.getTimer().isFinished()) {
                this.fState = 0;
            } else {
                return true;
            }
        }
        return false;
    }

    protected void setParameterNameKeys() {
        this.getTimer().setNameKey("block.OffDelay");
    }
}

